// PageSettingDDNS.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingDDNS.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "Include\CommonFun.h"


// CPageSettingDDNS dialog

IMPLEMENT_DYNAMIC(CPageSettingDDNS, CDialog)

CPageSettingDDNS::CPageSettingDDNS(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingDDNS::IDD, pParent)
{

}

CPageSettingDDNS::~CPageSettingDDNS()
{
}

void CPageSettingDDNS::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IPADDRESS_DDNSIP, m_IpAddrDDNSIP);
	DDX_Control(pDX, IDC_EDIT_DDNSPORT, m_EditPort);
	DDX_Control(pDX, IDC_EDIT_DDNSUSER, m_EditUser);
	DDX_Control(pDX, IDC_EDIT_DDNSPWD, m_EditPwd);
}


BEGIN_MESSAGE_MAP(CPageSettingDDNS, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SETDDNS, &CPageSettingDDNS::OnBnClickedButtonSetddns)
END_MESSAGE_MAP()


// CPageSettingDDNS message handlers

void  CPageSettingDDNS::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_SETDDNS, GetText(IDS_SETTING_DNSSET));
	SetDlgItemText(IDC_STATIC_DDNSIP, GetText(IDS_SETTING_DNSIP));
	SetDlgItemText(IDC_STATIC_DDNSPORT, GetText(IDS_SETTING_DNSPORT));
	SetDlgItemText(IDC_STATIC_DDNSUSER, GetText(IDS_SETTING_DNSUSER));
	SetDlgItemText(IDC_STATIC_DDNSPWD, GetText(IDS_SETTING_DNSPWD));
	SetDlgItemText(IDC_BUTTON_SETDDNS, GetText(IDS_SETTING_SETDDNS));
}

int CPageSettingDDNS::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();
	m_IpAddrDDNSIP.SetWindowText((LPCTSTR)_pdecParam->m_ddnsIP);
	m_EditUser.SetWindowText((LPCTSTR)_pdecParam->m_ddnsUser);
	m_EditPwd.SetWindowText((LPCTSTR)_pdecParam->m_ddnsPass);
	SetDlgItemInt(IDC_EDIT_DDNSPORT, _pdecParam->m_ddnsPort);

	m_EditUser.SetLimitText(15);
	m_EditPwd.SetLimitText(15);
	m_EditPort.SetLimitText(15);

	return 0;
}

void CPageSettingDDNS::OnBnClickedButtonSetddns()
{
	CString szDDnsIp= _T("");
	CString szUserName = _T("");
	CString szPwd = _T("");
	int iPort = -1;

	try
	{
		GetDlgItemText(IDC_IPADDRESS_DDNSIP, szDDnsIp);
		GetDlgItemText(IDC_EDIT_DDNSUSER, szUserName);
		GetDlgItemText(IDC_EDIT_DDNSPWD, szPwd);
		CString szPort = _T("");
		GetDlgItem(IDC_EDIT_DDNSPORT)->GetWindowText(szPort);
		iPort = atoi(CT2CA(szPort));
	}
	catch (...)
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	if(iPort > 65535 || iPort < 0)
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_PARAM),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	if (szUserName == "" || szPwd == "")
	{
		MessageBox(GetText(IDS_SETTING_INVALIDPARA),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	int iRet = DEC_ClientSetDDNS(m_lLogonID, (LPSTR)(LPCTSTR)szDDnsIp, (LPSTR)(LPCTSTR)szUserName,
		(LPSTR)(LPCTSTR)szPwd,iPort);
	if (iRet == 0)
	{
		MessageBox(GetText(IDS_SETTING_SETOK),_T(""),MB_OK|MB_TOPMOST);
	}
}

BOOL CPageSettingDDNS::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CPageSettingDDNS::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_DNSABSTRACT:
		{
			/*TDECPARAM* pdecParam =(TDECPARAM*) pData->tParam.tDecParam;
			m_IpAddrDDNSIP.SetWindowText((LPCTSTR)pdecParam->m_ddnsIP);
			m_EditUser.SetWindowText((LPCTSTR)pdecParam->m_ddnsUser);
			m_EditPwd.SetWindowText((LPCTSTR)pdecParam->m_ddnsPass);
			SetDlgItemInt(IDC_EDIT_DDNSPORT, pdecParam->m_ddnsPort);*/
		}
		break;
	}
}
